// some models

#include <StdAfx.h>
#include "funcheader.h"
#include "CConvenienceExports.h"


HRESULT CreateCone()
{
	START_METHOD("Create Cone")

	HRESULT status = CONV_SUCCESS;

	double x=0.0, y=0.0,  z=0.0,  radius=0.1;

	IApplication *pdApplication = NULL;
	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	IVector *center = NULL;
	IVector *start = NULL;
	IVector *end = NULL;
	IBasicStraight *curve1 = NULL;
	IBasicStraight *curve2 = NULL;
	IBasicStraight *curve3 = NULL;
	ICurve *curve4 = NULL;
	IPlane *l_zPlane = NULL;
	IGeometric *localGeometric = NULL;
	ISketch *initialSketch = NULL;
	ISketch *pSketch = NULL;
	ILine *l_circle = NULL;
	IPartDocument *newPart = NULL;
	IGeometry *localGeometry = NULL;
	IDirection *pDirection = NULL;
	ILine *pLine = NULL;
	
	// Get the application
	status = GetProDESKTOPApplication(&pdApplication);
	CHECK_RETURN_STATUS(status)

	status = pdApplication->NewPart(&newPart);
	CHECK_RETURN_STATUS(status)

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	status = (GetCLASS(Vector))->CreateVector(x, y, z, &center);
	CHECK_RETURN_STATUS(status)

	localGeometric = CAST(IGeometric, activeWorkplane);

	status = localGeometric->GetGeometry(&localGeometry);
	CHECK_RETURN_STATUS(status)

	l_zPlane = CAST(IPlane, localGeometry);

	status = l_zPlane->GetNormal(&pDirection);
	CHECK_RETURN_STATUS(status)

 	status = (GetCLASS(Vector))->CreateVector(x, y, z, &start);
	CHECK_RETURN_STATUS(status)

	status = (GetCLASS(Vector))->CreateVector(x+.1, y, z, &end);
	CHECK_RETURN_STATUS(status)

    status = (GetCLASS(BasicStraight))->CreateBasicStraightTwoPoints(start, end, &curve1);
	CHECK_RETURN_STATUS(status)

	status = activeSketch->CreateLine(CAST(ICurve, curve1), &pLine);
	CHECK_RETURN_STATUS(status)

	status = (GetCLASS(Vector))->CreateVector(x, y, z, &start);
	CHECK_RETURN_STATUS(status)

	status = (GetCLASS(Vector))->CreateVector(x, y+.2, z, &end);
	CHECK_RETURN_STATUS(status)

    status = (GetCLASS(BasicStraight))->CreateBasicStraightTwoPoints(start, end, &curve2);
	CHECK_RETURN_STATUS(status)

	status = activeSketch->CreateLine(CAST(ICurve, curve2), &pLine);
	CHECK_RETURN_STATUS(status)

	status = (GetCLASS(Vector))->CreateVector(x+.1, y, z, &start);
	CHECK_RETURN_STATUS(status)

	status = (GetCLASS(Vector))->CreateVector(x, y+.2, z, &end);
	CHECK_RETURN_STATUS(status)

    status = (GetCLASS(BasicStraight))->CreateBasicStraightTwoPoints(start, end, &curve3);
	CHECK_RETURN_STATUS(status)

	status = activeSketch->CreateLine(CAST(ICurve, curve3), &pLine);
	CHECK_RETURN_STATUS(status)

	//Get active workplane
	status = activeGraphicDoc->GetActiveWorkplane(&activeWorkplane);
	CHECK_RETURN_STATUS(status)

	status = activeGraphicDoc->GetActiveSketch(&initialSketch);
	CHECK_RETURN_STATUS(status)

	//Create axis 
	IRevolution *pRev=NULL;
	IDesign *pDesign = NULL;


	status = (GetCLASS(Vector))->CreateVector(x, y, z, &start);
	CHECK_RETURN_STATUS(status)

	status = (GetCLASS(Vector))->CreateVector(x, y+0.2, z, &end);
	CHECK_RETURN_STATUS(status)

	status = (GetCLASS(BasicStraight))->CreateBasicStraightTwoPoints(start, end, &curve1);
	CHECK_RETURN_STATUS(status)

	status = initialSketch->CreateLine(CAST(ICurve, curve1), &pLine);
	CHECK_RETURN_STATUS(status)

	//Set the axis as construction line
	pLine->SetConstruction(VARIANT_TRUE);

	//Revolution .
	status = activePart->GetDesign(&pDesign);
	CHECK_RETURN_STATUS(status)

	status = CAST(IRevolutionClass2, GetCLASS(Revolution))->CreateRevolution2(pDesign, initialSketch, CAST(IGeometric, pLine), 6.28, 0, 0, TRUE, 0, &pRev);
	CHECK_RETURN_STATUS(status)

	IPartOthers *part1 = CAST(IPartOthers, activePart);

	status = CommitToProDESKTOP("CreateRevolution");
	CHECK_RETURN_STATUS(status)

	activePart->UpdateDesign();

	status = CommitToProDESKTOP("UpdateDesign");
	CHECK_RETURN_STATUS(status)

	END_METHOD("End Cone")
}

HRESULT CreateCylinder() 
{
	START_METHOD("CreateCylinder")
	
	HRESULT status = CONV_SUCCESS;

	double x=0.0, y=0.0,  z=0.0,  radius=0.1;
	
	IApplication *pdApplication = NULL;
	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;
	
	IVector *center = NULL;
	IBasicCircle *curve = NULL;
	IPlane *l_zPlane = NULL;
	IGeometric *localGeometric = NULL;
	IGeometry *pGeometry = NULL;
	IExtrusion *l_extrusion = NULL;
	IDesign *pDesign = NULL;
	IDirection *pDirection = NULL;
	IPartDocument *newPart = NULL;
    
	ILine *l_circle = NULL;

	// Get the application
	status = GetProDESKTOPApplication(&pdApplication);
	CHECK_RETURN_STATUS(status)

	status = pdApplication->NewPart(&newPart);
	CHECK_RETURN_STATUS(status)

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	status = (GetCLASS(Vector))->CreateVector(x, y, z, &center);
	CHECK_RETURN_STATUS(status)

	localGeometric = CAST(IGeometric, activeWorkplane);
	CHECK_RETURN_STATUS(status)
	
	status = localGeometric->GetGeometry (&pGeometry);
	CHECK_RETURN_STATUS(status)
	
	l_zPlane = CAST(IPlane,pGeometry);

	status = l_zPlane->GetNormal(&pDirection);
	CHECK_RETURN_STATUS(status)

	status = (GetCLASS(BasicCircle))->CreateBasicCircle (center, pDirection, radius, &curve);
	CHECK_RETURN_STATUS(status)

	status = activeSketch->CreateLine(CAST(ICurve, curve), &l_circle);
	CHECK_RETURN_STATUS(status)

    status = activePart->GetDesign(&pDesign);
	CHECK_RETURN_STATUS(status)

	status = (GetCLASS(Extrusion))->CreateExtrusion(pDesign, activeSketch, 0.05, 0, 0, 0, 1, 0, &l_extrusion);
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("CreateExtrusion");
	CHECK_RETURN_STATUS(status)

	status = activePart->UpdateDesign();
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("UpdateDesign");
	CHECK_RETURN_STATUS(status)

	END_METHOD("CreateCylinder")

}

HRESULT RectangularBlock() 
{
	START_METHOD("Rectangular Block")
	
	double x=0.0, y=0.0,  z=0.0;
	HRESULT status = CONV_SUCCESS;
	IVector *center = NULL;
	IVector *start = NULL;
	IVector *end = NULL;
	IBasicStraight *curve1, *curve2, *curve3, *curve4 = NULL;
	IPlane *l_zPlane;
	IGeometric *localGeometric;
	IExtrusion *l_extrusion;
	IDesign *pDesign = NULL;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;
	IApplication *pdApplication = NULL;
	IPartDocument *newPart = NULL;
	ILine *pLine = NULL;
	IGeometry *pGeometry = NULL;
	IDirection *pDirection = NULL;

	// Get the application
	status = GetProDESKTOPApplication(&pdApplication);
	CHECK_RETURN_STATUS(status)

	pdApplication->NewPart(&newPart);
	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	status = (GetCLASS(Vector))->CreateVector(x, y, z, &center);

	localGeometric = CAST(IGeometric, activeWorkplane);

	status = localGeometric->GetGeometry (&pGeometry);
	CHECK_RETURN_STATUS(status)

	l_zPlane = CAST(IPlane, pGeometry);
	
	status = l_zPlane->GetNormal(&pDirection);
	CHECK_RETURN_STATUS(status)

 	status = (GetCLASS(Vector))->CreateVector(x, y, z, &start);
	CHECK_RETURN_STATUS(status)

	status = (GetCLASS(Vector))->CreateVector(x+.2, y, z, &end);
	CHECK_RETURN_STATUS(status)

    status = (GetCLASS(BasicStraight))->CreateBasicStraightTwoPoints(start, end, &curve1);
	CHECK_RETURN_STATUS(status)

	status = activeSketch->CreateLine(CAST(ICurve, curve1), &pLine);
	CHECK_RETURN_STATUS(status)

	status = (GetCLASS(Vector))->CreateVector(x, y, z, &start);
	CHECK_RETURN_STATUS(status)

	status = (GetCLASS(Vector))->CreateVector(x, y+.2, z, &end);
	CHECK_RETURN_STATUS(status)

    status = (GetCLASS(BasicStraight))->CreateBasicStraightTwoPoints(start, end, &curve2);
	CHECK_RETURN_STATUS(status)

	status = activeSketch->CreateLine(CAST(ICurve, curve2), &pLine);
	CHECK_RETURN_STATUS(status)

	status = (GetCLASS(Vector))->CreateVector(x, y+.2, z, &start);
	CHECK_RETURN_STATUS(status)

	status = (GetCLASS(Vector))->CreateVector(x+.2, y+.2, z, &end);
	CHECK_RETURN_STATUS(status)

    status = (GetCLASS(BasicStraight))->CreateBasicStraightTwoPoints(start, end, &curve3);
	CHECK_RETURN_STATUS(status)

	status = activeSketch->CreateLine(CAST(ICurve, curve3), &pLine);
	CHECK_RETURN_STATUS(status)

	status = (GetCLASS(Vector))->CreateVector(x+.2, y, z, &start);
	CHECK_RETURN_STATUS(status)

	status = (GetCLASS(Vector))->CreateVector(x+.2, y+.2, z, &end);
	CHECK_RETURN_STATUS(status)

    status = (GetCLASS(BasicStraight))->CreateBasicStraightTwoPoints(start, end, &curve4);
	CHECK_RETURN_STATUS(status)

	status = activeSketch->CreateLine(CAST(ICurve, curve4), &pLine);
	CHECK_RETURN_STATUS(status)

    status = activePart->GetDesign(&pDesign);
	CHECK_RETURN_STATUS(status)

	status = (GetCLASS(Extrusion))->CreateExtrusion(pDesign, activeSketch, 0.05, 0, 0, 0, 1, 0, &l_extrusion);
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("CreateExtrusion");
	CHECK_RETURN_STATUS(status)

	status = activePart->UpdateDesign();
	CHECK_RETURN_STATUS(status)
	
	status = CommitToProDESKTOP("UpdateDesign");
	CHECK_RETURN_STATUS(status)

	END_METHOD("Rectangular Block")
}

HRESULT Torous() 
{
	START_METHOD("Torous")
	
	HRESULT status = CONV_SUCCESS;

	double x=0.0, y=0.0,  z=0.0,  radius=0.05;

	IApplication *pdApplication = NULL;
	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;
	
	IVector *center = NULL;
	IBasicCircle *curve = NULL;
	IPlane *l_zPlane = NULL;
	IGeometric *localGeometric = NULL;

	ISketch *initialSketch = NULL;
	ISketch *pSketch = NULL;
	ILine *l_circle = NULL;
	IPartDocument *newPart = NULL;
	IDirection *pDirection = NULL;
	IGeometry *pGeometry = NULL;

	// Get the application
	status = GetProDESKTOPApplication(&pdApplication);
	CHECK_RETURN_STATUS(status)

	pdApplication->NewPart(&newPart);
	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	status = (GetCLASS(Vector))->CreateVector(x, y+.1, z, &center);
	CHECK_RETURN_STATUS(status)

	localGeometric = CAST(IGeometric, activeWorkplane);

	status = localGeometric->GetGeometry (&pGeometry);
	CHECK_RETURN_STATUS(status)

	l_zPlane = CAST(IPlane, pGeometry);

	status = l_zPlane->GetNormal(&pDirection);
	CHECK_RETURN_STATUS(status)

	status = (GetCLASS(BasicCircle))->CreateBasicCircle (center, pDirection, radius, &curve);
	CHECK_RETURN_STATUS(status)

	status = activeSketch->CreateLine(CAST(ICurve, curve), &l_circle);
	CHECK_RETURN_STATUS(status)

	// Get active workplane
	status = activeGraphicDoc->GetActiveWorkplane(&activeWorkplane);
	CHECK_RETURN_STATUS(status)

	status = activeGraphicDoc->GetActiveSketch(&initialSketch);
	CHECK_RETURN_STATUS(status)


	// create Axis 
	IBasicStraight *curve1 = NULL;
	IRevolution *pRev = NULL;
	IVector *start = NULL;
	IVector *end = NULL;
	IDesign *pDesign = NULL;

	status = (GetCLASS(Vector))->CreateVector(x+.2, y, z, &start);
	CHECK_RETURN_STATUS(status)

	status = (GetCLASS(Vector))->CreateVector(x, y+0.2, z, &end);
	CHECK_RETURN_STATUS(status)

	status = (GetCLASS(BasicStraight))->CreateBasicStraightTwoPoints(start, end, &curve1);
	CHECK_RETURN_STATUS(status)

	status = initialSketch->CreateLine(CAST(ICurve, curve1), &l_circle);
	CHECK_RETURN_STATUS(status)

	//Set the axis as construction line
	l_circle->SetConstruction(VARIANT_TRUE);

	//revolution
	status = activePart->GetDesign(&pDesign);
	CHECK_RETURN_STATUS(status)

	status = CAST(IRevolutionClass2, GetCLASS(Revolution))->CreateRevolution2(pDesign, initialSketch, CAST(IGeometric, l_circle), 6.28, 0, 0, TRUE, 0, &pRev);
	CHECK_RETURN_STATUS(status)

	IPartOthers *part1 = CAST(IPartOthers, activePart); 
	status = CommitToProDESKTOP("CreateRevolution");
	CHECK_RETURN_STATUS(status)

	status = activePart->UpdateDesign();
	CHECK_RETURN_STATUS(status)
	
	status = CommitToProDESKTOP("UpdateDesign");
	CHECK_RETURN_STATUS(status)

	END_METHOD("Torous")
}
